// ConfigurePanelTimeZone.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "ConfigurePanelTimeZone.h"
#include <afxtempl.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigurePanelTimeZone dialog


CConfigurePanelTimeZone::CConfigurePanelTimeZone(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigurePanelTimeZone::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigurePanelTimeZone)
	m_AcctName = _T("");
	//}}AFX_DATA_INIT
}
CConfigurePanelTimeZone ::CConfigurePanelTimeZone(IApplication *pApp):CDialog(CConfigurePanelTimeZone::IDD, NULL)
{
	pApplication = pApp;
//	pTZ.CreateInstance(__uuidof(TimeZone));
	
}

void CConfigurePanelTimeZone::LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}
void CConfigurePanelTimeZone::LoadPanels()
{
	int index = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index,sAcctName);
	_variant_t vPanels;
	vPanels.Clear();
	long lAccountID = _wtoi(sAcctName);
	pApplication->GetPanelsByAcctID(lAccountID,&vPanels);
	if(vPanels.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Panels");
			return;
	}
		
		long uBound =0 ;
		IHWDevice *pPanels =NULL;
		COleSafeArray sa(vPanels);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		//BSTR bstrPanel;
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pPanels);
			if (pPanels != NULL)
			{	
				CString sPanelid;
				sPanelid.Format(L"%ld",pPanels->HWDeviceID);
				m_PanelList.AddString(sPanelid);	
				pPanels->Release();
			}
			pDisp->Release();
		}
}

void CConfigurePanelTimeZone ::LoadTimeZones()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = m_AcctName.AllocSysString();
		
		_variant_t vTZs;
		vTZs.Clear();
		pApplication->GetAllTimezones(&vTZs); // get timezone details of particular account  in WP-CS database server
		
		if(vTZs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ITimeZone *pTZ = NULL;
		
		COleSafeArray sa(vTZs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		int none = 0;
		CString sNone;
		sNone.Format(L"%d", none);
		m_TZList.AddString(sNone);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TimeZoneID);
				m_TZList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_TZList.SetCurSel(0);
}
void CConfigurePanelTimeZone::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigurePanelTimeZone)
	DDX_Control(pDX, IDC_LIST_PANEL_TZLIST, m_PanelTZList);
	DDX_Control(pDX, IDC_PANELLIST, m_PanelList);
	DDX_Control(pDX, IDC_TZLIST, m_TZList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Text(pDX, IDC_ACCTNAME, m_AcctName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigurePanelTimeZone, CDialog)
	//{{AFX_MSG_MAP(CConfigurePanelTimeZone)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_PANELLIST, OnSelchangePanellist)
	ON_BN_CLICKED(IDC_CONFIGURE, OnConfigure)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigurePanelTimeZone message handlers

BOOL CConfigurePanelTimeZone::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigurePanelTimeZone::OnSelchangeAcctlist() 
{
	m_PanelList.ResetContent();
	m_TZList.ResetContent();
	CString sAcctName;
	BSTR pBstrAcctName;
	long lAccountID;
	int indexaccount = 0;
	indexaccount = m_AcctList.GetCurSel();
	if(indexaccount<0)
	{
		lAccountID = 0;
	}
	else
	{
		m_AcctList.GetLBText(indexaccount,sAcctName);
		lAccountID = _wtoi(sAcctName);
	}
	UpdateData(TRUE);
	pApplication->GetAccountNameByAcctID(lAccountID,&pBstrAcctName);
	UpdateData(TRUE);
	m_AcctName = CString(pBstrAcctName);
	UpdateData(FALSE);
	LoadPanels();
	LoadTimeZones();
}

void CConfigurePanelTimeZone::OnSelchangePanellist() 
{
	m_PanelTZList.ResetContent();
	LoadPanelTimezones();	
}

void CConfigurePanelTimeZone::OnConfigure() 
{
	long lAccountID;
	CString sAcctName;
	int indexaccount = 0;
	indexaccount = m_AcctList.GetCurSel();
	if(indexaccount<0)
	{
		lAccountID = 0;
	}
	else
	{
		m_AcctList.GetLBText(indexaccount,sAcctName);
		lAccountID = _wtoi(sAcctName);
	}

	int indexpanel = m_PanelList.GetCurSel();
	CString sPanelID;
	long lHWDeviceID;
	if(indexpanel<0)
	{
		lHWDeviceID = 0;
	}
	else
	{
		m_PanelList.GetLBText(indexpanel,sPanelID);
		lHWDeviceID = _wtoi(sPanelID);
	}

	CArray<int,int> sels;
	VARIANT vTZs;
	int n = m_TZList.GetSelCount();
	COleSafeArray saTZs;
	saTZs.CreateOneDim(VT_I4,n);
	sels.SetSize(n);
	m_TZList.GetSelItems(n, sels.GetData());
	for(long i = 0; i < n; i++)                                                  
	{                                                      
		CString sTZID;       
		long lTZID = 0;
		m_TZList.GetText(sels[i], sTZID);
		lTZID = _wtoi(sTZID);
		saTZs.PutElement(&i,&lTZID);
	}
	vTZs = saTZs.Detach();
	long lStatus = 0;
	pApplication->ConfigurePanelTimeZone(lAccountID,lHWDeviceID,&vTZs,&lStatus);

	switch(lStatus)
	{
		case  105:
			AfxMessageBox(L"Invalid account");
			return;
		case  501:
			AfxMessageBox(L"Invalid panel");
			return;
		case  506:
			AfxMessageBox(L"The time zone is associated with an output cant be replaced with new time zone");
			return;
		case  611:
			AfxMessageBox(L"The time zone is associated with a entrance/reader cant be replaced with new time zone");
			return;
		case  613:
			AfxMessageBox(L"The time zones given contain a system time zone. For P series panels these are configured by default. Configuration failed.");
			return;
		case  507:
			AfxMessageBox(L"The time zone is associated with an input cant be replaced with new time zone");
			return;
		case  508:
			AfxMessageBox(L"The time zone is associated with PIN cant be replaced with new time zone");
			return;
		case  509:
			AfxMessageBox(L"The time zone is associated with atleast a group cant be replaced with new time zone");
			return;
		case  510:
			AfxMessageBox(L"The time zone is associated with atleast one ADV(output/group) within the panel and cant be replaced with new time zone");
			return;
		case  511:
			AfxMessageBox(L"The time zone is associated with atleast one Reader cant be replaced with new time zone");
			return;
		case  512:
			AfxMessageBox(L"The time zone is associated with atleast one MIRO Input cant be replaced with new time zone");
			return;
		case  513:
			AfxMessageBox(L"The time zone is associated with atleast one MIRO output cant be replaced with new time zone");
			return;
		case  605:
			AfxMessageBox(L"Invalid Time zone");
			return;
		case 612:
			AfxMessageBox(L"Invalid Time zone slots");
			return;
		case 514:
			AfxMessageBox(L"Timezone is associated with one of the FIN4000 Panel's Operation Modes");
			return;
		case 0:
			AfxMessageBox(L"Time Zone Range Configuration to panel succeeded");
			CDialog::OnOK();
			return;
	}
}

void CConfigurePanelTimeZone::LoadPanelTimezones()
{
	//select account name
	long lAccountID;
	CString sAcctName;
	int indexaccount = 0;
	indexaccount = m_AcctList.GetCurSel();
	if(indexaccount<0)
	{
		lAccountID = 0;
	}
	else
	{
		m_AcctList.GetLBText(indexaccount,sAcctName);
		lAccountID = _wtoi(sAcctName);
	}
	//Select Panel ID
	int index = m_PanelList.GetCurSel();
	CString sPanelID;
	 // Minor UI Update -- Guru
	if(index<0)
		return;
	m_PanelList.GetLBText(index,sPanelID);
	long lPanelID = _wtoi(sPanelID);
	
	_variant_t vTZs;
	vTZs.Clear();
	pApplication->GetConfiguredTimezonesByPanel(lPanelID, &vTZs); // get timezone details of particular account  in WP-CS database server
	
	if(vTZs.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	ITimeZone *pTZ = NULL;
	
	COleSafeArray sa(vTZs);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);

	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
		if (pTZ != NULL)
		{
			CString sTZid;
			sTZid.Format(L"%ld",pTZ->TimeZoneID);
			m_PanelTZList.AddString(sTZid);
			pTZ->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}
